/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.storage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.scheduler.v2.Schedulers;
import net.impactdev.impactor.api.storage.Storage;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.economy.storage.EconomyStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.future.ThrowingRunnable;
import net.impactdev.impactor.core.utility.future.ThrowingSupplier;

public final class EconomyStorage
implements Storage {
    private final EconomyStorageImplementation implementation;

    public EconomyStorage(EconomyStorageImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public void init() throws Exception {
        this.implementation.init();
    }

    @Override
    public void shutdown() throws Exception {
        this.implementation.shutdown();
    }

    @Override
    public CompletableFuture<Void> meta(PrettyPrinter printer) {
        return EconomyStorage.run(() -> this.implementation.meta(printer));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Boolean> hasAccount(Currency currency, UUID uuid) {
        return EconomyStorage.supply(() -> this.implementation.hasAccount(currency, uuid));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Account> account(Currency currency, UUID uuid, Account.AccountModifier modifier) {
        return EconomyStorage.supply(() -> this.implementation.account(currency, uuid, modifier));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> save(Account account) {
        return EconomyStorage.run(() -> this.implementation.save(account));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Multimap<Currency, Account>> accounts() {
        ArrayListMultimap results = ArrayListMultimap.create();
        return EconomyStorage.run(() -> this.lambda$accounts$4((Multimap)results)).thenApply(arg_0 -> EconomyStorage.lambda$accounts$5((Multimap)results, arg_0));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> delete(Currency currency, UUID uuid) {
        return EconomyStorage.run(() -> this.implementation.delete(currency, uuid));
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> logTransaction(EconomyTransaction transaction) {
        return CompletableFuture.completedFuture(null);
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Void> sync(Account account, Instant since) {
        return CompletableFuture.completedFuture(null);
    }

    @CanIgnoreReturnValue
    public CompletableFuture<Boolean> purge() {
        return EconomyStorage.supply(this.implementation::purge);
    }

    private static CompletableFuture<Void> run(ThrowingRunnable runnable2) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Schedulers.require(Scheduler.ASYNCHRONOUS).executor());
    }

    private static <T> CompletableFuture<T> supply(ThrowingSupplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.supply();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, Schedulers.require(Scheduler.ASYNCHRONOUS).executor());
    }

    private static /* synthetic */ Multimap lambda$accounts$5(Multimap results, Void ignore) {
        return results;
    }

    private /* synthetic */ void lambda$accounts$4(Multimap results) throws Exception {
        this.implementation.accounts((Multimap<Currency, Account>)results);
    }
}

